#!/usr/bin/env python

import argparse
import pprint
import sys

from paddlex_hps_client import triton_request, utils
from tritonclient import grpc as triton_grpc

OCR_IMAGE_PATH = "./ocr.jpg"
LAYOUT_IMAGE_PATH = "./layout.jpg"


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--image", type=str, required=True)
    parser.add_argument("--url", type=str, default="localhost:8001")
    args = parser.parse_args()

    client = triton_grpc.InferenceServerClient(args.url)
    input_ = {"image": utils.prepare_input_file(args.image)}
    output = triton_request(client, "table-recognition", input_)
    if output["errorCode"] != 0:
        print(f"Error code: {output['errorCode']}", file=sys.stderr)
        print(f"Error message: {output['errorMsg']}", file=sys.stderr)
        sys.exit(1)
    result = output["result"]
    utils.save_output_file(result["ocrImage"], OCR_IMAGE_PATH)
    print(f"Output image saved at {OCR_IMAGE_PATH}")
    utils.save_output_file(result["layoutImage"], LAYOUT_IMAGE_PATH)
    print(f"Output image saved at {LAYOUT_IMAGE_PATH}")
    print("\nDetected tables:")
    pprint.pp(result["tables"])


if __name__ == "__main__":
    main()
