#!/bin/bash

set -e

export LANG='C.UTF-8'
export PADDLEX_HPS_LOGGING_LEVEL='INFO'
export PADDLEX_HPS_SERVER_DIR="${PWD}"

export PADDLEX_HPS_PIPELINE_CONFIG_PATH="${PADDLEX_HPS_PIPELINE_CONFIG_PATH:-$(realpath pipeline_config.yaml)}"

find model_repo -mindepth 1 -maxdepth 1 -type d -print0 | while IFS= read -r -d '' dir_; do
    if [ -f "${dir_}/config_${PADDLEX_HPS_DEVICE_TYPE}.pbtxt" ]; then
        cp -f "${dir_}/config_${PADDLEX_HPS_DEVICE_TYPE}.pbtxt" "${dir_}/config.pbtxt"
    fi
done

if [ -d common_mods ]; then
    export PYTHONPATH="$(realpath common_mods):${PYTHONPATH}"
fi

tritonserver \
    --model-repository=model_repo \
    --backend-config=python,shm-default-byte-size=104857600,shm-growth-byte-size=10485760
