from typing import Dict, List

from pydantic import BaseModel

from common.base_model import BaseFaceRecognitionModel
from common.index_data_utils import deserialize_index_data, serialize_index_data


class RemoveImagesFromIndexInput(BaseModel):
    ids: List[int]
    indexKey: str


class RemoveImagesFromIndexResult(BaseModel):
    idMap: Dict[int, str]


class TritonPythonModel(BaseFaceRecognitionModel):
    def _get_input_model_type(self):
        return RemoveImagesFromIndexInput

    def _get_result_model_type(self):
        return RemoveImagesFromIndexResult

    def _execute(self, input, log_id):
        index_storage = self._context["index_storage"]
        index_data_bytes = index_storage.get(input.indexKey)
        index_data = deserialize_index_data(index_data_bytes)

        index_data = self._pipeline.remove_index(input.ids, index_data)

        index_data_bytes = serialize_index_data(index_data)
        index_storage.set(input.indexKey, index_data_bytes)

        return RemoveImagesFromIndexResult(idMap=index_data.id_map)

    def _no_predictors(self):
        return True
