import os
import os.path

from paddlex_hps_server import BaseTritonPythonModel
from paddlex_hps_server.storage import create_storage

# Do we need a lock?
DEFAULT_INDEX_DIR = os.path.join(
    os.getenv("PADDLEX_HPS_SERVER_DIR", os.path.dirname(__file__)), ".indexes"
)


class BaseFaceRecognitionModel(BaseTritonPythonModel):
    def initialize(self, args):
        super().initialize(args)
        self._context = {}
        index_storage = None
        if self._app_config.extra:
            if "index_storage" in self._app_config.extra:
                index_storage = create_storage(self._app_config.extra["index_storage"])
        if index_storage is None:
            index_storage = create_storage(
                {"type": "file_system", "directory": DEFAULT_INDEX_DIR}
            )
        self._context["index_storage"] = index_storage
